function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 242);

T = World_Economy_Cartel_cost_inv_shocks.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(115) = exp(y(30))*exp(y(33))*T(99);
T(116) = T(37)+T(36)*y(24)*(-(exp(y(30))*T(27)));
T(117) = (-(exp(y(113))*exp(y(40))*exp(y(105))));
T(118) = (-T(22))*T(99);
T(119) = T(29)*(-T(22))+T(22)*y(69);
T(120) = T(45)+T(55)+T(56);
T(121) = exp(y(6))*params(6)*exp(y(55))*params(5)*exp(params(5)*y(10));
T(122) = params(32)*y(128)*(-(exp(y(35))*exp(y(39))))+params(32)*y(124)*(-(exp(y(35))*(-exp(y(39)))))+params(32)*y(121)*exp(y(35))*params(6)*exp(y(115))*params(5)*params(5)*exp(params(5)*y(39));
T(123) = (-(T(27)*(exp(y(30))*exp(y(11))+y(42)*(-exp(y(11)))-params(6)*exp(y(55))*params(5)*exp(params(5)*y(11)))));
T(124) = T(36)*y(24)*T(27)*params(6)*params(5)*exp(y(55))*(params(5)-1)*exp(y(11)*(params(5)-1))+T(36)*y(22)*T(123);
T(125) = T(36)*y(24)*T(27)*params(6)*params(5)*exp(y(55))*(params(5)-1)*exp(y(11)*(params(5)-1))+T(36)*y(22)*(-(T(27)*(-(params(6)*exp(y(55))*params(5)*exp(params(5)*y(11))))));
T(126) = exp(y(7))*exp(y(56))*params(6)*params(5)*exp(params(5)*y(11));
T(127) = exp(y(113))*params(6)*params(5)*exp(y(115))*(params(5)-1)*(params(5)-1)*exp(y(40)*(params(5)-1));
T(128) = y(75)*T(127);
T(129) = (-(exp(y(113))*(exp(y(40))*exp(y(105))+y(106)*(-exp(y(40)))-params(6)*exp(y(115))*params(5)*params(5)*exp(params(5)*y(40)))));
T(130) = y(72)*T(129);
T(131) = T(36)*y(22)*(-(T(27)*(1-exp(y(11)))))+T(36)*T(27)*y(24);
T(132) = T(8)*getPowerDeriv(T(8),T(13),2);
T(133) = T(8)*T(132);
T(134) = T(57)+T(133);
T(135) = T(8)*getPowerDeriv(T(8),T(1),2);
T(136) = T(8)*T(135);
T(137) = T(58)+T(136);
T(138) = params(11)*T(137);
T(139) = getPowerDeriv(T(9),T(10),2);
T(140) = exp(y(108))*getPowerDeriv(exp(y(108)),T(1),1);
T(141) = getPowerDeriv(T(71),T(10),2);
T(142) = exp(y(45))*getPowerDeriv(exp(y(45)),T(11),2);
T(143) = exp(y(45))*T(142);
T(144) = T(60)+T(143);
T(145) = y(67)*(-(T(19)*T(16)*T(61)*T(89)+T(5)*T(19)*T(61)*T(91)))+y(66)*(-(T(17)*T(3)*T(62)*T(91)+T(3)*T(16)*T(62)*T(93)));
T(146) = (-(T(5)*T(19)*T(16)*T(60)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(52))));
T(147) = (-(T(17)*T(3)*T(16)*T(60)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(52))));
T(148) = y(67)*T(146)+y(66)*T(147);
T(149) = exp(y(109))*getPowerDeriv(exp(y(109)),T(11),1);
T(150) = (1-params(11))*(1-params(3))*exp(T(1)*y(114))*T(149);
T(151) = (-(T(64)*(T(79)*T(78)*(1-params(11))*params(3)*exp(T(1)*y(114))*T(149)+T(81)*T(76)*(1-params(11))*params(3)*exp(T(1)*y(114))*T(149))));
T(152) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3),1);
T(153) = T(5)*T(152);
T(154) = T(2)*T(95)*T(153);
T(155) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,1);
T(156) = (-(T(5)*(T(16)*T(61)*T(155)+T(19)*T(61)*T(90)*T(153))));
T(157) = T(16)*T(62)*T(152)+T(3)*T(62)*T(90)*T(153);
T(158) = getPowerDeriv(T(6),T(13),2);
T(159) = T(90)*T(89)*T(152)+T(3)*T(89)*T(153)*T(158);
T(160) = T(15)*T(16)*T(152)+T(3)*T(15)*T(90)*T(153);
T(161) = getPowerDeriv(T(6),T(1),2);
T(162) = T(2)*(T(95)*T(89)*T(152)+T(3)*T(89)*T(153)*T(161));
T(163) = (-(exp(y(47)*(1-params(3)))*T(1)*exp(T(1)*y(52))*params(3)*exp(y(13)*params(3))));
T(164) = T(16)*T(105)*T(155)+T(19)*T(105)*T(90)*T(153);
T(165) = T(16)*T(106)*T(152)+T(3)*T(106)*T(90)*T(153);
T(166) = T(20)*getPowerDeriv(T(20),params(3),2);
T(167) = T(20)*T(166);
T(168) = T(65)+T(167);
T(169) = getPowerDeriv(T(67),T(1),2);
T(170) = T(63)*(T(68)*T(64)*T(168)+T(64)*T(65)*T(64)*T(65)*T(169));
T(171) = getPowerDeriv(T(67),T(13),2);
T(172) = T(77)*T(64)*T(168)+T(64)*T(65)*T(64)*T(65)*T(171);
T(173) = T(20)*getPowerDeriv(T(20),params(3)-1,2);
T(174) = T(20)*T(173);
T(175) = T(81)+T(174);
T(176) = exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),1);
T(177) = (-(params(9)*T(176)/(1+params(8))));
T(178) = getPowerDeriv(T(30),(-params(14)),1);
T(179) = T(177)*T(178);
T(180) = (-((-(params(1)*T(86)*T(179)))/(T(31)*T(31))));
T(181) = (-((-(params(1)*T(99)*T(179)))/(T(31)*T(31))));
T(182) = T(4)*getPowerDeriv(T(4),1+params(8),2);
T(183) = T(4)*T(182);
T(184) = T(83)+T(183);
T(185) = (-(params(9)*T(184)/(1+params(8))));
T(186) = getPowerDeriv(T(28),(-params(14)),2);
T(187) = T(85)*T(185)+T(84)*T(84)*T(186);
T(188) = T(4)*getPowerDeriv(T(4),1-params(3),2);
T(189) = T(4)*T(188);
T(190) = T(89)+T(189);
T(191) = T(90)*T(3)*T(190)+T(3)*T(89)*T(3)*T(89)*T(158);
T(192) = (-(T(89)*T(19)*T(18)*T(91)+T(16)*T(18)*T(19)*T(190)+T(89)*T(19)*T(18)*T(91)+T(5)*T(19)*T(18)*T(191)));
T(193) = T(4)*getPowerDeriv(T(4),(-params(3)),2);
T(194) = T(4)*T(193);
T(195) = T(93)+T(194);
T(196) = (-(T(3)*T(15)*T(91)*T(93)+T(17)*T(3)*T(15)*T(191)+T(3)*T(15)*T(91)*T(93)+T(3)*T(15)*T(16)*T(195)));
T(197) = T(2)*(T(95)*T(3)*T(190)+T(3)*T(89)*T(3)*T(89)*T(161));
T(198) = T(29)*T(29)*T(29)*T(29);
T(199) = (-((T(29)*T(29)*(-(T(98)*T(187)))-(-(T(86)*T(98)))*(T(29)*T(86)+T(29)*T(86)))/T(198)));
T(200) = exp(y(48))*T(84)*T(186);
T(201) = T(29)*T(29)*(-(T(98)*T(200)))-(-(T(98)*T(99)))*(T(29)*T(86)+T(29)*T(86));
T(202) = (-(T(89)*T(19)*T(16)*T(105)+T(5)*T(19)*T(91)*T(105)));
T(203) = y(67)*T(202);
T(204) = y(66)*(-(T(93)*T(3)*T(16)*T(106)+T(17)*T(3)*T(91)*T(106)));
T(205) = T(3)*T(89)*T(95)*T(107);
T(206) = exp(y(110))*getPowerDeriv(exp(y(110)),1-params(3),1);
T(207) = T(63)*(T(68)*T(65)*T(206)+T(64)*T(65)*T(169)*T(66)*T(206));
T(208) = exp(y(110))*getPowerDeriv(exp(y(110)),(-params(3)),1);
T(209) = T(77)*T(65)*T(206)+T(64)*T(65)*T(171)*T(66)*T(206);
T(210) = exp(y(110))*getPowerDeriv(exp(y(110)),1+params(8),1);
T(211) = (-(params(9)*T(210)/(1+params(8))));
T(212) = getPowerDeriv(T(97),(-params(14)),1);
T(213) = params(1)*T(211)*T(212);
T(214) = (-((-(params(1)*T(86)*exp(y(15))*T(178)))/(T(31)*T(31))));
T(215) = (-((-(params(1)*T(99)*exp(y(15))*T(178)))/(T(31)*T(31))));
T(216) = T(84)*exp(y(48))*T(186);
T(217) = T(29)*T(99)+T(29)*T(99);
T(218) = (-((T(29)*T(29)*(-(T(98)*T(216)))-(-(T(86)*T(98)))*T(217))/T(198)));
T(219) = T(99)+exp(y(48))*exp(y(48))*T(186);
T(220) = exp(y(50))*getPowerDeriv(exp(y(50)),T(26),2);
T(221) = exp(y(50))*T(220);
T(222) = T(102)+T(221);
T(223) = T(36)*y(22)*(-(T(27)*(-(exp(params(5)*y(11))*params(6)*exp(y(55))))))+T(36)*y(24)*T(27)*params(6)*params(5)*exp(y(55))*exp(y(11)*(params(5)-1));
T(224) = (-(exp(y(113))*(exp(y(40))*exp(y(105))+(1-exp(y(40)))*y(106)-params(6)*exp(y(115))*exp(params(5)*y(40)))));
T(225) = (-(exp(y(47)*(1-params(3)))*exp(y(13)*params(3))*T(1)*T(1)*exp(T(1)*y(52))));
T(226) = (-(T(17)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(52))));
T(227) = T(7)*(1-params(11))*T(1)*T(1)*exp(T(1)*y(52));
T(228) = T(64)*T(65)*T(68)*(1-params(11))*T(1)*exp(T(1)*y(114));
T(229) = T(74)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(114));
T(230) = T(65)*T(76)*T(229)+T(66)*T(78)*T(229);
T(231) = T(79)*T(78)*T(74)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(114))+T(81)*T(76)*T(74)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(114));
T(232) = T(52)+y(72)*(-(exp(y(113))*(-(params(6)*exp(y(115))*params(5)*exp(params(5)*y(40))))));
T(233) = exp(y(63))*getPowerDeriv(exp(y(63)),params(5)-1,2);
T(234) = exp(y(63))*T(233);
T(235) = T(111)+T(234);
T(236) = (-(exp(y(33))*exp(y(56))*params(6)*T(235)));
T(237) = T(29)*T(236);
T(238) = params(32)*exp(y(35))*params(6)*exp(y(115))*params(5)*exp(params(5)*y(39));
T(239) = params(32)*exp(y(36))*params(6)*exp(y(116))*params(5)*exp(params(5)*y(40));
T(240) = T(36)*(-(T(27)*exp(y(30))*exp(y(11))));
T(241) = T(36)*(-(T(27)*(-(exp(params(5)*y(11))*params(6)*exp(y(55))))));
T(242) = T(36)*T(27)*params(6)*params(5)*exp(y(55))*exp(y(11)*(params(5)-1));

end
